import pandas as pd
import pickle
from decision_company import read_csv_file, create_date_offset, filter_by_date

# Load the dataset
atp_tennis = read_csv_file("atp_tennis.csv")

# Filter the dataset to only include matches from the last five years
five_years_ago = last_date - create_date_offset(years=5)
recent_matches = filter_by_date(atp_tennis, 'Date', five_years_ago)

print(recent_matches)
pickle.dump(recent_matches,open("./ref_result/recent_matches.pkl","wb"))